﻿using Helper;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using ZSMusic.BLL;
using ZSMusic.Model;

namespace WEB
{
    public partial class research : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string result = "";
            try
            {
                Music m = MusicHelper.ReSearch(Request["artist"], Request["name"], Convert.ToDouble(Request["similar"]), Request["type"]);
                if (Request["redirect"] == "1")
                {
                    switch (Request["type"])
                    {
                        case "all":
                        case "url":
                            Response.Redirect(m.Url);
                            break;
                        case "pic":
                            Response.Redirect(m.PicUrl);
                            break;
                        case "lrc":
                            result = m.Lrc;
                            break;
                        default:
                            throw new Exception("参数错误 参数名:type");
                    }
                }
                else
                {
                    result = JsonConvert.SerializeObject(m);
                }
            }
            catch (Exception ex)
            {
                result = JsonConvert.SerializeObject(ex);
            }
            Response.Write(result);
        }
    }
}